﻿using System;
using System.Collections.Generic;
using System.Linq;
using BMS.Utils;
using BMS.VistaIntegration.Data;
using BMS.VistaIntegration.Via.Commands.EIS;
using BMS.VistaIntegration.Via.Commands.EntityCommands;

namespace BMS.VistaIntegration.Via.Commands.WF
{
    public class ListPatientAppointmentsFromClinicCommand : BaseListPeriodCommand<PatientAppointment>
    {
        public ListPatientAppointmentsFromClinicCommand(ViaVistAQuery query)
            : base(query)
        {
        }

        public Dictionary<string, IEnumerable<Patient>> ClinicPatients
        {
            get;
            set;
        }

        public string CurrentPatientIen
        {
            get;
            private set;
        }

        public string CurrentClinicIen
        {
            get;
            private set;
        }

        public override List<PatientAppointment> Execute(ViaVistASession session)
        {
            var result = Enumerable.Empty<PatientAppointment>();

            foreach (var clinic in this.ClinicPatients)
            {
                this.CurrentClinicIen = clinic.Key;
                foreach (var patient in clinic.Value)
                {
                    this.CurrentPatientIen = patient.IEN;
                    var localResult = base.Execute(session);
                    localResult.ForEach(x => x.Patient = patient);

                    result = result.Union(localResult);
                }
            }

            return result.ToList();
        }

        protected override string GetTarget()
        {
            return "ListPatientAppointment";
        }

        protected override IEnumerable<object> GetCriteria()
        {
            if (string.IsNullOrEmpty(this.CurrentPatientIen))
            {
                throw new InvalidOperationException("CurrentPatientIen property is not set");
            }

            yield return this.CurrentPatientIen;
            yield return this.MaxCount;
            yield return this.StartDate.GetValueOrDefault(MinDate);
            yield return this.EndDate.GetValueOrDefault(this.MaxDate);
            yield return this.CurrentClinicIen; // This parameter can be null
            yield return this.From;
        }

        protected override IDependencySource GetDependencySource()
        {
            return PatientAppointmentDependencySource.Instance;
        }
    }

    internal sealed class PatientAppointmentDependencySource : IDependencySource<PatientAppointment>
    {
        private static IDependencySource instance;

        private PatientAppointmentDependencySource()
        {
        }

        public static IDependencySource Instance
        {
            get
            {
                if (instance == null)
                {
                    instance = new PatientAppointmentDependencySource();
                }

                return instance;
            }
        }

        public IEnumerable<DependentEntityInfo> GetDependentTypes()
        {
            yield return new DependentEntityInfo<HospitalLocation>(ListHospitalLocationCommand.Target, ListHospitalLocationCommand.ArgumentsCount, ".01");
        }

        public List<PatientAppointment> PostProcessEntities(ViaVistAQuery query, List<PatientAppointment> result)
        {
            result.ForEach(r =>
            {
                r.Patient = query.EntitySetCache.GetEntity<Patient>(query, r.PatientId);
            });

            return result;
        }
    }
}
